/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jpos.config.JposEntry;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleEntryRegistry;
import jpos.config.simple.xml.SimpleXmlRegPopulator;

public class ConfiguredDevicesPanel
extends Component {
    private static final long serialVersionUID = 8895419610452248342L;

    public Component make() {
        JPanel mainPanel = new JPanel(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(Box.createVerticalStrut(20));
        JLabel label = new JLabel("Below is a list of the devices found in your jpos.xml file.");
        mainPanel.add(label);
        SimpleEntryRegistry reg = new SimpleEntryRegistry((JposRegPopulator)new SimpleXmlRegPopulator());
        reg.load();
        Object[] colNames = new String[]{"Category", "Logical Name", "Vendor", "Product Name"};
        Object[][] data = new Object[reg.getSize()][4];
        Enumeration entriesEnum = reg.getEntries();
        int count = 0;
        while (entriesEnum.hasMoreElements()) {
            JposEntry entry = (JposEntry)entriesEnum.nextElement();
            Object[] row = new Object[]{entry.getProp("deviceCategory").getValueAsString(), entry.getLogicalName(), entry.getProp("vendorName").getValueAsString(), entry.getProp("productName").getValueAsString()};
            data[count] = row;
            ++count;
        }
        JTable table = new JTable(data, colNames);
        JScrollPane scrollPane = new JScrollPane(table);
        table.setPreferredScrollableViewportSize(new Dimension(700, 200));
        TableColumn column = null;
        int i = 0;
        while (i < 4) {
            column = table.getColumnModel().getColumn(i);
            int maxsize = 0;
            int j = 0;
            while (j < count) {
                int size = ((String)data[j][i]).length();
                if (maxsize < size * 5) {
                    maxsize = size * 5;
                }
                ++j;
            }
            column.setPreferredWidth(maxsize);
            ++i;
        }
        mainPanel.add(scrollPane);
        return mainPanel;
    }
}

