/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

public class FirmwareUpdateDlg
extends JDialog
implements ActionListener,
StatusUpdateListener {
    private static final long serialVersionUID = 1180348090398413114L;
    private Object deviceObject;
    private Method compareMethod = null;
    private Method updateMethod = null;
    private Method getCapUpdateFirmware = null;
    private Method getCapCompareFirmwareVersion = null;
    private Method addStatusUpdateListener = null;
    private Boolean capUpdateFirmware = new Boolean(false);
    private Boolean capCompareFirmwareVersion = new Boolean(false);
    private JRadioButton updateRadio;
    private JRadioButton compareRadio;
    private JTextField fileNameTF;
    private JTextArea messageWindow;
    private JProgressBar progressBar;
    private JButton goButton;
    private JButton closeButton;

    public FirmwareUpdateDlg(Object object) throws Exception {
        JposException je;
        Object[] args;
        this.deviceObject = object;
        Class<?> c = object.getClass();
        Method[] theMethods = c.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            if (theMethods[i].getName().equals("compareFirmwareVersion")) {
                this.compareMethod = theMethods[i];
            } else if (theMethods[i].getName().equals("updateFirmware")) {
                this.updateMethod = theMethods[i];
            } else if (theMethods[i].getName().equals("getCapUpdateFirmware")) {
                this.getCapUpdateFirmware = theMethods[i];
            } else if (theMethods[i].getName().equals("getCapCompareFirmwareVersion")) {
                this.getCapCompareFirmwareVersion = theMethods[i];
            } else if (theMethods[i].getName().equals("addStatusUpdateListener")) {
                this.addStatusUpdateListener = theMethods[i];
            }
            ++i;
        }
        if (this.compareMethod == null || this.updateMethod == null || this.getCapUpdateFirmware == null || this.getCapCompareFirmwareVersion == null) {
            throw new Exception("Object passed to FirmwareUpdateDialog() does not support the firmware interface.\nPerhaps the Service Object is not UPOS v1.9 complient.");
        }
        try {
            args = new Object[]{};
            this.capCompareFirmwareVersion = (Boolean)this.getCapCompareFirmwareVersion.invoke(this.deviceObject, args);
            this.capUpdateFirmware = (Boolean)this.getCapUpdateFirmware.invoke(this.deviceObject, args);
        }
        catch (InvocationTargetException e) {
            je = (JposException)e.getTargetException();
            JOptionPane.showMessageDialog(null, "exception getting device caps:\n" + je.getMessage(), "Exception", 0);
        }
        catch (IllegalAccessException e) {
            JOptionPane.showMessageDialog(null, "call to a getCap function threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
        }
        try {
            args = new Object[]{this};
            this.addStatusUpdateListener.invoke(this.deviceObject, args);
        }
        catch (InvocationTargetException e) {
            je = (JposException)e.getTargetException();
            JOptionPane.showMessageDialog(null, "exception calling addStatusUpdateListener:\n" + je.getMessage(), "Exception", 0);
        }
        catch (IllegalAccessException e) {
            JOptionPane.showMessageDialog(null, "addStatusUpdateListener threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
        }
        this.setModal(true);
        this.setSize(500, 300);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.setContentPane(mainPanel);
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        mainPanel.add(row1);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        mainPanel.add(row2);
        JPanel row3 = new JPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        mainPanel.add(row3);
        JPanel row4 = new JPanel();
        row4.setLayout(new BoxLayout(row4, 0));
        mainPanel.add(row4);
        JPanel row5 = new JPanel();
        row5.setLayout(new BoxLayout(row5, 0));
        mainPanel.add(row5);
        JPanel textBox = new JPanel();
        textBox.setLayout(new BoxLayout(textBox, 1));
        row2.add(textBox);
        ButtonGroup group = new ButtonGroup();
        this.updateRadio = new JRadioButton("Update");
        this.updateRadio.setEnabled(this.capUpdateFirmware);
        this.updateRadio.setSelected(true);
        group.add(this.updateRadio);
        row1.add(this.updateRadio);
        this.compareRadio = new JRadioButton("Compare Versions");
        this.compareRadio.setSelected(false);
        this.compareRadio.setEnabled(this.capCompareFirmwareVersion);
        group.add(this.compareRadio);
        row1.add(this.compareRadio);
        row1.add(Box.createHorizontalStrut(150));
        this.goButton = new JButton("Go");
        this.goButton.setActionCommand("Go");
        this.goButton.addActionListener(this);
        row1.add(this.goButton);
        row1.add(Box.createHorizontalStrut(5));
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("Close");
        this.closeButton.addActionListener(this);
        row1.add(this.closeButton);
        JLabel label = new JLabel("Select the file you would like to use.");
        textBox.add(label);
        row3.add(Box.createHorizontalStrut(10));
        label = new JLabel("Filename:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        row3.add(label);
        this.fileNameTF = new JTextField();
        this.fileNameTF.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.fileNameTF.setPreferredSize(new Dimension(200, 25));
        row3.add(this.fileNameTF);
        row3.add(Box.createHorizontalStrut(10));
        JButton browseButton = new JButton("Browse");
        browseButton.setActionCommand("Browse");
        browseButton.addActionListener(this);
        row3.add(browseButton);
        row3.add(Box.createHorizontalStrut(80));
        this.progressBar = new JProgressBar(0, 100);
        row4.add(this.progressBar);
        this.messageWindow = new JTextArea();
        this.messageWindow.setBorder(new BevelBorder(1));
        JScrollPane scrollPane = new JScrollPane(this.messageWindow);
        scrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        row5.add(scrollPane);
        if (!this.capUpdateFirmware.booleanValue() && !this.capCompareFirmwareVersion.booleanValue()) {
            this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "capUpdateFirmware and capCompareFirmwareVersion are both false for this device.\n" + " Nothing to do.");
            this.goButton.setEnabled(false);
        }
        this.setTitle("Firmware Utilities");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JFileChooser chooser;
        int returnVal;
        if (ae.getActionCommand().equals("Close")) {
            this.setVisible(false);
        } else if (ae.getActionCommand().equals("Go")) {
            if (this.compareRadio.isSelected()) {
                try {
                    int[] result = new int[1];
                    Object[] args = new Object[]{this.fileNameTF.getText()};
                    args[1] = result;
                    this.compareMethod.invoke(this.deviceObject, args);
                }
                catch (InvocationTargetException e) {
                    JposException je = (JposException)e.getTargetException();
                    JOptionPane.showMessageDialog(null, "compareFirmwareVersion threw an exception:\n" + je.getMessage(), "Exception", 0);
                }
                catch (IllegalAccessException e) {
                    JOptionPane.showMessageDialog(null, "call to compareFirmwareVersion threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
                }
                catch (Exception e) {
                    try {
                        if (e.getClass().equals(Class.forName("JposException"))) {
                            JOptionPane.showMessageDialog(null, "call to compareFirmwareVersion threw a JposException:\n" + e.getMessage(), "Exception", 0);
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        JOptionPane.showMessageDialog(null, "Exception in compareFirmwareVersion:\n" + e.getMessage(), "Exception", 0);
                    }
                }
            } else if (this.updateRadio.isSelected()) {
                this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "The update firmware process is starting..\n");
                this.goButton.setEnabled(false);
                this.closeButton.setEnabled(false);
                UpdateThread thread = new UpdateThread();
                thread.start();
            }
        } else if (ae.getActionCommand().equals("Browse") && (returnVal = (chooser = new JFileChooser()).showOpenDialog(this)) == 0) {
            this.fileNameTF.setText(chooser.getSelectedFile().getPath());
        }
    }

    public void statusUpdateOccurred(StatusUpdateEvent sue) {
        int status = sue.getStatus();
        if (status >= 2100 && status < 2200) {
            this.progressBar.setValue(status - 2100);
            return;
        }
        switch (status) {
            case 2200: {
                this.progressBar.setValue(100);
                this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "The update firmware process has completed successfully.\n");
                break;
            }
            case 2205: {
                this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "********************************************************************************\n" + "The update firmware process succeeded, however the Service and/or \n" + "the physical device cannot be returned to the state they were in before the \n" + "update firmware process started. The Service has restored all properties to \n" + "their default initialization values. To ensure consistent Service and \n" + "physical device states, the application needs to close the Service, then \n" + "open, claim, and enable again, and also restore all custom application settings.\n" + "********************************************************************************\n");
                break;
            }
            case 2201: {
                this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "********************************************************************************\n" + "The update firmware process failed but the device is still operational. \n" + "********************************************************************************\n");
                break;
            }
            case 2202: {
                this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "********************************************************************************\n" + "The update firmware process failed and the device is neither usable\n" + "nor recoverable through software. The device requires service to be returned to an \n" + "operational state.\n" + "********************************************************************************\n");
                break;
            }
            case 2203: {
                this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "********************************************************************************\n" + "The update firmware process failed and the device will\n" + "not be operational until another attempt to update the\n" + "firmware is successful.\n" + "********************************************************************************\n");
                break;
            }
            case 2204: {
                this.messageWindow.setText(String.valueOf(this.messageWindow.getText()) + "********************************************************************************\n" + "The update firmware process failed and the device is in an indeterminate state.\n" + "********************************************************************************\n");
            }
        }
        this.goButton.setEnabled(false);
        this.closeButton.setEnabled(true);
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
        }

        @Override
        public void run() {
            try {
                Object[] args = new Object[]{FirmwareUpdateDlg.this.fileNameTF.getText()};
                FirmwareUpdateDlg.this.updateMethod.invoke(FirmwareUpdateDlg.this.deviceObject, args);
            }
            catch (InvocationTargetException e) {
                JposException je = (JposException)e.getTargetException();
                JOptionPane.showMessageDialog(null, "updateFirmware threw an exception:\n" + je.getMessage(), "Exception", 0);
            }
            catch (IllegalAccessException e) {
                JOptionPane.showMessageDialog(null, "call to updateFirmware threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
            }
            catch (Exception e) {
                try {
                    if (e.getClass().equals(Class.forName("JposException"))) {
                        JOptionPane.showMessageDialog(null, "call to updateFirmware threw a JposException:\n" + e.getMessage(), "Exception", 0);
                    }
                }
                catch (ClassNotFoundException ex) {
                    JOptionPane.showMessageDialog(null, "Exception in updateFirmware:\n" + e.getMessage(), "Exception", 0);
                }
            }
        }
    }
}

