/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MainButtonPanel
extends JPanel {
    private static final long serialVersionUID = 8227244715825526726L;
    public JTextField logicalNameTextField;
    public JLabel currentStatus;
    private JButton openButton;
    private JButton claimButton;
    private JButton releaseButton;
    private JButton closeButton;
    private JButton infoButton;
    private JButton oceButton;
    private JButton exitButton;
    private JButton statsButton;

    public MainButtonPanel(ActionListener actionListener, String defaultSelection) {
        JPanel buttonGroupPanel = new JPanel();
        buttonGroupPanel.setLayout(new BoxLayout(buttonGroupPanel, 1));
        JPanel buttonRow1 = new JPanel();
        buttonRow1.setLayout(new BoxLayout(buttonRow1, 0));
        buttonGroupPanel.add(buttonRow1);
        JPanel buttonRow2 = new JPanel();
        buttonRow2.setLayout(new BoxLayout(buttonRow2, 0));
        buttonGroupPanel.add(buttonRow2);
        JLabel logicalNameLabel = new JLabel("Logical name: ");
        buttonRow1.add(logicalNameLabel);
        this.logicalNameTextField = new JTextField(15);
        this.logicalNameTextField.setText(defaultSelection);
        buttonRow1.add(this.logicalNameTextField);
        buttonRow1.add(Box.createRigidArea(new Dimension(130, 0)));
        this.currentStatus = new JLabel("State: Unknown");
        buttonRow1.add(this.currentStatus);
        buttonRow1.add(Box.createRigidArea(new Dimension(100, 0)));
        this.openButton = new JButton("Open");
        this.openButton.setActionCommand("open");
        this.openButton.addActionListener(actionListener);
        this.openButton.setToolTipText("open a device");
        buttonRow2.add(this.openButton);
        buttonRow2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.claimButton = new JButton("Claim");
        this.claimButton.setActionCommand("claim");
        this.claimButton.addActionListener(actionListener);
        this.claimButton.setToolTipText("claim a device");
        buttonRow2.add(this.claimButton);
        buttonRow2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.releaseButton = new JButton("Release");
        this.releaseButton.setActionCommand("release");
        this.releaseButton.addActionListener(actionListener);
        this.releaseButton.setToolTipText("release a device");
        buttonRow2.add(this.releaseButton);
        buttonRow2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(actionListener);
        this.closeButton.setToolTipText("close a device");
        buttonRow2.add(this.closeButton);
        buttonRow2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.infoButton = new JButton("Info");
        this.infoButton.setActionCommand("info");
        this.infoButton.addActionListener(actionListener);
        this.infoButton.setToolTipText("information about device");
        buttonRow2.add(this.infoButton);
        buttonRow2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statsButton = new JButton("Statistics");
        this.statsButton.setActionCommand("stats");
        this.statsButton.addActionListener(actionListener);
        this.statsButton.setToolTipText("view / reset / update device statistics");
        buttonRow2.add(this.statsButton);
        buttonRow2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.oceButton = new JButton("O/C/E");
        this.oceButton.setActionCommand("oce");
        this.oceButton.addActionListener(actionListener);
        this.oceButton.setToolTipText("open claim enable <fast mode>");
        buttonRow2.add(this.oceButton);
        buttonRow2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.exitButton = new JButton("EXIT");
        this.exitButton.setActionCommand("exit");
        this.exitButton.addActionListener(actionListener);
        this.exitButton.setToolTipText("exit program");
        buttonRow2.add(this.exitButton);
        this.add(buttonGroupPanel);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
    }

    public void action(ActionEvent ae) {
        ae.getActionCommand().equals("open");
        ae.getActionCommand().equals("claim");
        ae.getActionCommand().equals("release");
        ae.getActionCommand().equals("close");
        ae.getActionCommand().equals("info");
        ae.getActionCommand().equals("oce");
        if (ae.getActionCommand().equals("exit")) {
            System.out.println("...Exit JavaPOS Tester...");
            System.exit(0);
        }
    }

    public String getLogicalName() {
        String logicalName = this.logicalNameTextField.getText();
        return logicalName;
    }

    public static String getStatusString(int statusCode) {
        String val;
        switch (statusCode) {
            case 3: {
                val = "JPOS_S_BUSY";
                break;
            }
            case 1: {
                val = "JPOS_S_CLOSED";
                break;
            }
            case 4: {
                val = "JPOS_S_ERROR";
                break;
            }
            case 2: {
                val = "JPOS_S_IDLE";
                break;
            }
            default: {
                val = "Unknown State";
            }
        }
        return val;
    }

    public static String getErrorName(int errorCode) {
        String val;
        switch (errorCode) {
            case 0: {
                val = "JPOS_SUCCESS";
                break;
            }
            case 101: {
                val = "JPOS_E_CLOSED";
                break;
            }
            case 102: {
                val = "JPOS_E_CLAIMED";
                break;
            }
            case 103: {
                val = "JPOS_E_NOTCLAIMED";
                break;
            }
            case 104: {
                val = "JPOS_E_NOSERVICE";
                break;
            }
            case 105: {
                val = "JPOS_E_DISABLED";
                break;
            }
            case 106: {
                val = "JPOS_E_ILLEGAL";
                break;
            }
            case 107: {
                val = "JPOS_E_NOHARDWARE";
                break;
            }
            case 108: {
                val = "JPOS_E_OFFLINE";
                break;
            }
            case 109: {
                val = "JPOS_E_NOEXIST";
                break;
            }
            case 110: {
                val = "JPOS_E_EXISTS";
                break;
            }
            case 111: {
                val = "JPOS_E_FAILURE";
                break;
            }
            case 112: {
                val = "JPOS_E_TIMEOUT";
                break;
            }
            case 113: {
                val = "JPOS_E_BUSY";
                break;
            }
            case 114: {
                val = "JPOS_E_EXTENDED";
                break;
            }
            default: {
                val = "Unknown";
            }
        }
        return val;
    }
}

