/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.io;

import com.xl.jpos.io.DataReceivedListener;
import com.xl.jpos.io.IOPortConfig;
import com.xl.jpos.io.IOSerialPort;
import com.xl.util.Logger;
import java.util.Enumeration;
import java.util.Vector;

public abstract class IOPort {
    protected static final String os = System.getProperty("os.name").toUpperCase();
    protected static final boolean inWindows = os.contains("WINDOWS");
    protected Logger log = new Logger("IOPort");
    protected Vector<DataReceivedListener> dataReceivedListeners = new Vector();
    protected IOPortConfig cfg;
    protected boolean bOpen = false;

    public IOPort(IOPortConfig cfg) {
        this.cfg = cfg;
    }

    protected void finalize() {
        this.closePort();
    }

    public abstract boolean openPort();

    public abstract boolean closePort();

    public abstract void changeBaudRate(int var1);

    public boolean isOpen() {
        this.log.debug("isOpen: " + this.bOpen);
        return this.bOpen;
    }

    public int sendData(String strBuf) {
        return this.sendData(strBuf.getBytes(), strBuf.length());
    }

    public int sendData(byte[] buf) {
        return this.sendData(buf, buf.length);
    }

    public abstract int sendData(byte[] var1, int var2);

    public void addDataReceivedListener(DataReceivedListener drl) {
        this.dataReceivedListeners.addElement(drl);
        this.log.debug("addDataReceivedListener.");
    }

    public void removeDataReceivedListener(DataReceivedListener drl) {
        this.dataReceivedListeners.removeElement(drl);
        this.log.debug("removeDataReceivedListener.");
    }

    protected void fireDataReceivedEvent(byte[] buf, int len) {
        Enumeration<DataReceivedListener> elements = this.dataReceivedListeners.elements();
        while (elements.hasMoreElements()) {
            elements.nextElement().onDataReceived(buf, len);
        }
        this.log.debug("fireDataReceivedEvent. dataReceivedListeners.size:" + this.dataReceivedListeners.size() + "; buf len:" + len);
    }

    public static IOPort creatPort(IOPortConfig cfg) {
        if (cfg.getPortType() == 0) {
            return new IOSerialPort(cfg);
        }
        return null;
    }
}

