/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.io;

import com.xl.util.Logger;

public class IOPortConfig {
    protected static Logger log = new Logger("IOPortConfig");
    public static final int IOPORT_TYPE_SERIAL = 0;
    protected int portType = 0;
    protected String portName;
    protected int portNo;
    protected int baudRate;
    protected int dataBits;
    protected int stopBits;
    protected int parity;

    public IOPortConfig(int ioport_type, String portName, int baudRate, int dataBits, int stopBits, String strParity) {
        this.portType = ioport_type;
        this.portName = portName;
        this.baudRate = baudRate;
        this.dataBits = dataBits > 8 || dataBits < 5 ? 8 : dataBits;
        this.stopBits = stopBits > 2 || stopBits < 1 ? 8 : stopBits;
        switch (strParity.charAt(0)) {
            case 'N': {
                this.parity = 0;
                break;
            }
            case 'E': {
                this.parity = 2;
                break;
            }
            case 'O': {
                this.parity = 1;
                break;
            }
            case 'S': {
                this.parity = 4;
                break;
            }
            case 'M': {
                this.parity = 3;
            }
        }
        this.portNo = 1;
        if (ioport_type == 0) {
            try {
                String[] aPorts;
                if (portName.toUpperCase().contains("COM") && (aPorts = portName.toUpperCase().split("COM")).length > 1) {
                    this.portNo = Integer.parseInt(aPorts[1].trim());
                }
                if (portName.toUpperCase().contains("TTYS")) {
                    aPorts = portName.toUpperCase().split("TTYS");
                    if (aPorts.length > 1) {
                        this.portNo = Integer.parseInt(aPorts[1].trim());
                    }
                } else {
                    this.portNo = Integer.parseInt(portName);
                }
            }
            catch (NumberFormatException err) {
                log.error("IOPortConfig construct NumberFormatException error:" + portName);
            }
        }
    }

    public int getPortType() {
        return this.portType;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public String getDeviceCategory() {
        return "Scanner";
    }
}

