/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.io;

import com.xl.jpos.io.IOPort;
import com.xl.jpos.io.IOPortConfig;
import com.xl.util.Logger;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;

public class IOSerialPort
extends IOPort
implements SerialPortEventListener {
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected SerialPort serialPort = null;
    protected CommPortIdentifier portId = null;
    protected byte[] readBuffer = new byte[1024];

    public IOSerialPort(IOPortConfig cfg) {
        super(cfg);
    }

    private CommPortIdentifier findPort(int portNo) {
        this.log.debug("findPort start: " + portNo);
        CommPortIdentifier commPortIdentifier = null;
        boolean bFound = false;
        String portName = "";
        String fPortName = "COM" + String.valueOf(portNo);
        String fPortName2 = "ttyS" + String.valueOf(portNo - 1);
        this.log.debug("findPort  " + fPortName + "," + fPortName2);
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            commPortIdentifier = (CommPortIdentifier)portList.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            portName = commPortIdentifier.getName();
            this.log.debug("findPort: portname:" + portName);
            if (!portName.equalsIgnoreCase(fPortName) && !portName.equalsIgnoreCase(fPortName2) && !portName.contains("ACM")) continue;
            bFound = true;
            break;
        }
        this.log.debug("findPort end: " + bFound);
        return bFound ? commPortIdentifier : null;
    }

    @Override
    public boolean openPort() {
        block8: {
            this.log.debug("openPort start. portname:" + this.cfg.getPortName());
            String portName = this.cfg.getPortName();
            int portNo = this.cfg.portNo;
            String strOS = IOPort.os;
            try {
                CommPortIdentifier commPortIdentifier = this.findPort(portNo);
                if (commPortIdentifier != null) {
                    try {
                        this.log.trace("Port: " + portName + ", as identified by ComPortIdentrifier");
                        if (commPortIdentifier.isCurrentlyOwned()) {
                            this.log.error("openPort Error: Port (" + portName + ") is currently in use");
                            throw new PortInUseException();
                        }
                        this.serialPort = commPortIdentifier.open("IOSerialPort", 2000);
                        this.serialPort.addEventListener((SerialPortEventListener)this);
                        this.serialPort.notifyOnDataAvailable(true);
                        this.setSerialPortParams();
                        this.inputStream = this.serialPort.getInputStream();
                        this.outputStream = this.serialPort.getOutputStream();
                        this.bOpen = true;
                        break block8;
                    }
                    catch (UnsupportedCommOperationException ucoe) {
                        this.log.error("UnsupportedCommOperationException: " + ucoe.getMessage());
                        throw ucoe;
                    }
                    catch (PortInUseException e) {
                        this.log.error("PortInUseException: " + e.getMessage());
                        break block8;
                    }
                    catch (TooManyListenersException e) {
                        this.log.error("TooManyListenersException: " + e.getMessage());
                        break block8;
                    }
                }
                this.log.error("Port: " + portName + ", not found");
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
        this.log.debug("openPort: " + this.bOpen);
        return this.bOpen;
    }

    private void setSerialPortParams() throws UnsupportedCommOperationException {
        this.serialPort.setSerialPortParams(this.cfg.getBaudRate(), this.cfg.getDataBits(), this.cfg.getStopBits(), this.cfg.getParity());
    }

    @Override
    public void changeBaudRate(int baudRate) {
        try {
            this.cfg.setBaudRate(baudRate);
            this.setSerialPortParams();
        }
        catch (UnsupportedCommOperationException e) {
            this.log.error("changeBaudRate: UnsupportedCommOperationException: " + e.getMessage());
        }
    }

    @Override
    public boolean closePort() {
        boolean result;
        block8: {
            result = true;
            try {
                if (this.serialPort == null) break block8;
                this.log.debug("closePort: serialPort != null");
                this.serialPort.notifyOnDataAvailable(false);
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                        this.inputStream = null;
                    }
                    catch (Exception ex) {
                        this.log.error("Error closing port: " + ex.getMessage());
                    }
                }
                if (this.outputStream != null) {
                    try {
                        this.outputStream.flush();
                        this.outputStream.close();
                        this.outputStream = null;
                    }
                    catch (IOException ex) {
                        this.log.error("Error closing port: " + ex.getMessage());
                    }
                }
                this.serialPort.removeEventListener();
                this.serialPort.close();
                this.serialPort = null;
                this.inputStream = null;
                this.outputStream = null;
            }
            catch (Exception e) {
                this.log.error("Error closing port: " + e.getMessage());
                result = false;
            }
        }
        this.bOpen = false;
        this.log.debug("closePort");
        return result;
    }

    @Override
    public int sendData(byte[] buf, int len) {
        if (len == 0 || buf == null || buf.length == 0) {
            return 0;
        }
        try {
            this.outputStream.write(buf);
            this.outputStream.flush();
            this.log.trace("sendData bytes[" + len + "]:" + Logger.bytes2HexString(buf, len));
        }
        catch (IOException e) {
            this.log.error("sendData IOException: " + e.getMessage());
        }
        return len;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 10: {
                this.log.trace("event.getEventType: BI");
                this.log.error("event.getEventType: BI");
                break;
            }
            case 7: {
                this.log.trace("event.getEventType: OE");
                break;
            }
            case 9: {
                this.log.trace("event.getEventType: FE");
                break;
            }
            case 8: {
                this.log.trace("event.getEventType: PE");
                break;
            }
            case 6: {
                this.log.trace("event.getEventType: CD");
                break;
            }
            case 3: {
                this.log.trace("event.getEventType: CTS");
                break;
            }
            case 4: {
                this.log.trace("event.getEventType: DSR");
                break;
            }
            case 5: {
                this.log.trace("event.getEventType: RI");
                break;
            }
            case 2: {
                this.log.trace("event.getEventType: OUTPUT_BUFFER_EMPTY");
                break;
            }
            case 1: {
                this.log.trace("event.getEventType: DATA_AVAILABLE");
                this.readDataFromPort();
                break;
            }
        }
    }

    public void readDataFromPort() {
        this.log.trace("readDataFromPort start");
        String readData = "";
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            int len = 0;
            while (this.inputStream.available() > 0) {
                len = this.inputStream.read(this.readBuffer);
                if (len <= 0) break;
                readData = String.valueOf(readData) + new String(this.readBuffer, 0, len);
                bs.write(this.readBuffer, 0, len);
            }
            byte[] bytesRead = bs.toByteArray();
            this.fireDataReceivedEvent(bytesRead, bytesRead.length);
        }
        catch (Exception e) {
            this.log.error("readDataFromPort error occured");
            this.log.error(e);
        }
        this.log.trace("readDataFromPort end. readData:" + readData);
    }
}

