/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.io;

import com.xl.jpos.io.IOSerialPort;
import com.xl.util.Logger;
import gnu.io.CommPortIdentifier;

class IOSerialPortWatcher
extends Thread {
    private static final Logger log = new Logger("IOSerialPortWatcher");
    private static final long TIMEOUT = 1000L;
    private IOSerialPort container;
    protected boolean needStopThread = true;

    protected IOSerialPortWatcher(IOSerialPort ioSerialPort) {
        this.container = ioSerialPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug("IOSerialPortWatcher start run.");
        long timeout = 1000L;
        try {
            while (!this.needStopThread) {
                IOSerialPortWatcher iOSerialPortWatcher = this;
                synchronized (iOSerialPortWatcher) {
                    this.wait(timeout);
                }
                timeout = 1000L;
                if (!this.needStopThread) {
                    CommPortIdentifier commPortIdentifier = this.container.watchNewPort();
                    if (commPortIdentifier == null) continue;
                    this.container.reopenPort(commPortIdentifier);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            log.error("interruptedException message:" + interruptedException.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex);
        }
        log.debug("IOSerialPortWatcher end run.");
    }
}

