/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.service;

import com.xl.jpos.service.ScannerEventContainer;
import com.xl.jpos.service.ScannerEventEntity;
import com.xl.util.Logger;
import java.util.LinkedList;
import java.util.Queue;

class ScannerEventDispatcher
extends Thread {
    private static final Logger log = new Logger("XLBaseService");
    private static final long TIMEOUT = 1000L;
    private Queue<ScannerEventEntity> queue = new LinkedList<ScannerEventEntity>();
    private ScannerEventContainer container;
    protected int eventCount = 0;
    protected int dataEventCount = 0;
    protected int errorEventCount = 0;
    protected boolean needStopThread = true;
    protected boolean dataEventEnabled = false;
    protected boolean freezeEvents = false;

    protected ScannerEventDispatcher(ScannerEventContainer scannerEventContainer) {
        this.container = scannerEventContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long timeout = 1000L;
        try {
            while (!this.needStopThread) {
                ScannerEventDispatcher scannerEventDispatcher = this;
                synchronized (scannerEventDispatcher) {
                    this.wait(timeout);
                }
                timeout = 1000L;
                if (this.needStopThread) break;
                if (this.freezeEvents || this.queue.size() <= 0) continue;
                ScannerEventEntity eventEntity = this.queue.peek();
                ScannerEventDispatcher scannerEventDispatcher2 = this;
                synchronized (scannerEventDispatcher2) {
                    boolean ifDispatchData = false;
                    boolean bl = ifDispatchData = eventEntity != null && (this.dataEventEnabled || eventEntity.eventType != ScannerEventEntity.EventType.Data);
                    if (eventEntity != null && eventEntity.eventType == ScannerEventEntity.EventType.Data) {
                        this.dataEventEnabled = false;
                    }
                    eventEntity = ifDispatchData ? this.queue.poll() : null;
                }
                if (eventEntity == null) continue;
                log.debug("ScannerDataEventDispatch start.");
                this.container.ScannerEventHandler(eventEntity);
                log.debug("BarcodeEventDispatch end.");
                if (this.freezeEvents || !this.dataEventEnabled || this.queue.size() <= 0) continue;
                timeout = 1L;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.getMessage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(ScannerEventEntity scannerEventEntity) {
        if (scannerEventEntity == null) {
            return;
        }
        if (scannerEventEntity.eventType == ScannerEventEntity.EventType.Data) {
            this.container.DataReceived();
        }
        ScannerEventDispatcher scannerEventDispatcher = this;
        synchronized (scannerEventDispatcher) {
            this.queue.add(scannerEventEntity);
            ++this.eventCount;
            if (scannerEventEntity.eventType == ScannerEventEntity.EventType.Data) {
                ++this.dataEventCount;
            } else if (scannerEventEntity.eventType == ScannerEventEntity.EventType.Error) {
                ++this.errorEventCount;
            }
            if (!this.freezeEvents) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScannerEventEntity RemoveHead() {
        ScannerEventEntity entity;
        ScannerEventDispatcher scannerEventDispatcher = this;
        synchronized (scannerEventDispatcher) {
            entity = this.queue.poll();
            if (entity != null) {
                --this.eventCount;
                if (entity.eventType == ScannerEventEntity.EventType.Data) {
                    --this.dataEventCount;
                } else if (entity.eventType == ScannerEventEntity.EventType.Error) {
                    --this.errorEventCount;
                }
            }
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Clear() {
        ScannerEventDispatcher scannerEventDispatcher = this;
        synchronized (scannerEventDispatcher) {
            while (this.RemoveHead() != null) {
            }
        }
    }
}

