/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.service;

import com.xl.jpos.io.DataReceivedListener;
import com.xl.jpos.io.IOPort;
import com.xl.jpos.io.IOPortConfig;
import com.xl.jpos.service.DeviceErrorStatusListener;
import com.xl.jpos.service.DirectIODataListener;
import com.xl.jpos.service.XLDeviceInfo;
import com.xl.jpos.service.XLException;
import com.xl.jpos.service.XLJposConst;
import com.xl.jpos.service.XLScanner;
import com.xl.util.Logger;
import com.xl.util.XLBarcode;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public abstract class XLDevice
implements DataReceivedListener,
XLJposConst {
    protected Logger log = new Logger("XLDevice");
    public XLDeviceInfo deviceInfo = null;
    protected IOPortConfig ioPortConfig = null;
    protected IOPort port = null;
    protected Vector deviceErrorListeners = new Vector();
    protected Vector deviceStatusListeners = new Vector();
    protected Vector directIODataListeners = new Vector();
    protected boolean bEnabled = false;
    protected boolean bAlive = false;
    protected int nTimeout = 5000;
    protected boolean bNeedBCC = false;
    protected int lastPos = 0;
    protected ByteArrayOutputStream bs = new ByteArrayOutputStream();
    Vector msgList = new Vector();
    protected Hashtable hTable;

    public XLDevice(XLDeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void claim(long lTimeout) throws XLException {
        String ioType;
        this.log.debug("XLDevice claim start:");
        if (this.port != null) {
            this.release();
        }
        if ((ioType = this.deviceInfo.getIOType()) != null && ioType != "") {
            this.log.info("BaseService open: IOType =  " + ioType);
            if (ioType.equalsIgnoreCase("serial")) {
                this.ioPortConfig = new IOPortConfig(0, this.deviceInfo.getPortName(), this.deviceInfo.getBaudrate(), this.deviceInfo.getDatabits(), this.deviceInfo.getStopbits(), this.deviceInfo.getParity());
            }
        }
        if (this.ioPortConfig == null) {
            this.log.error("BaseService open error: not init ioPortConfig.  ");
            throw new XLException(-2147483643, "Logical device not config io port rightly.");
        }
        this.port = IOPort.creatPort(this.ioPortConfig);
        if (!this.port.openPort()) {
            this.log.error("claim Error opening port");
            throw new XLException(-2147483644, "Port open error");
        }
        this.port.addDataReceivedListener(this);
        this.log.debug("XLDevice claim end.");
    }

    public void release() throws XLException {
        if (this.port != null && this.port.isOpen()) {
            this.log.trace("port.closePort()");
            this.port.closePort();
        }
        this.port.removeDataReceivedListener(this);
        this.log.trace("port.removeDataReceivedListener(this)");
        this.log.debug("XLDevice release");
    }

    public void close() throws XLException {
        if (this.port != null && this.port.isOpen()) {
            this.release();
        }
        if (this.port != null) {
            this.port = null;
        }
        this.log.debug("XLDevice close.");
    }

    protected int sendMsg(String strMsg) {
        this.log.debug("XLDevice sendMsg start:" + strMsg);
        StringBuffer msg = new StringBuffer();
        byte b = this.deviceInfo.getTxPrefix();
        if (b != 0) {
            msg.append((char)b);
        }
        msg.append(strMsg);
        b = this.deviceInfo.getTxTrailer();
        if (b != 0) {
            msg.append((char)b);
        }
        int iResult = this.port.sendData(msg.toString());
        this.log.debug("XLDevice sendMsg end:" + iResult);
        return iResult;
    }

    protected int sendData(byte[] data) {
        this.log.debug("XLDevice sendMsg start:" + Logger.bytes2HexString(data, data.length));
        byte prefix = this.deviceInfo.getTxPrefix();
        byte suffix = this.deviceInfo.getTxTrailer();
        byte[] cmds = XLBarcode.addPrefixTrailer(data, prefix, suffix);
        int iResult = this.port.sendData(cmds);
        this.log.debug("XLDevice sendMsg end:" + iResult);
        return iResult;
    }

    public XLDeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public abstract void setEnabled(boolean var1);

    public abstract boolean getEnabled();

    public abstract void SetParam(Set var1);

    public abstract String getModelNumber();

    public abstract String getSerialNumber();

    public abstract String getFirmwareVersion();

    public abstract boolean isAlive() throws XLException;

    public abstract int sendJoin();

    public abstract int sendReset();

    public abstract int directIO(int var1, int[] var2, Object var3) throws XLException;

    public abstract void reset() throws XLException;

    public void addDeviceErrorListener(DeviceErrorStatusListener del) {
        this.log.debug("addDeviceErrorListener");
        this.deviceErrorListeners.addElement(del);
        this.log.debug("addDeviceErrorListener");
    }

    public void removeDeviceErrorListener(DeviceErrorStatusListener del) {
        this.log.debug("removeDeviceErrorListener");
        this.deviceErrorListeners.removeElement(del);
        this.log.debug("removeDeviceErrorListener");
    }

    protected void fireDeviceErrorEvent(int errorCode) {
        this.log.debug("fireDeviceErrorEvent: " + errorCode);
        Enumeration e = this.deviceErrorListeners.elements();
        while (e.hasMoreElements()) {
            DeviceErrorStatusListener listener = (DeviceErrorStatusListener)e.nextElement();
            listener.onDeviceError(errorCode);
        }
        this.log.debug("fireDeviceErrorEvent");
    }

    public void addDeviceStatusListener(DeviceErrorStatusListener dsl) {
        this.log.debug("addDeviceStatusListener");
        this.deviceStatusListeners.addElement(dsl);
        this.log.debug("addDeviceStatusListener");
    }

    public void removeDeviceStatusListener(DeviceErrorStatusListener dsl) {
        this.log.debug("removeDeviceStatusListener");
        boolean re = this.deviceStatusListeners.removeElement(dsl);
        this.log.debug("removeDeviceStatusListener");
    }

    protected void fireDeviceStatusEvent(int statusCode) {
        this.log.debug("fireDeviceStatusEvent");
        int STATUS_ALIVE = 65336;
        int STATUS_NOT_ALIVE = 65335;
        int STATUS_ENABLED = 65334;
        int STATUS_NOT_ENABLED = 65333;
        if (statusCode == STATUS_ALIVE) {
            this.log.trace("fireDeviceStatusEvent: STATUS_ALIVE " + statusCode);
        }
        if (statusCode == STATUS_NOT_ALIVE) {
            this.log.trace("fireDeviceStatusEvent: STATUS_NOT_ALIVE " + statusCode);
        }
        if (statusCode == STATUS_ENABLED) {
            this.log.trace("fireDeviceStatusEvent: STATUS_ENABLED " + statusCode);
        }
        if (statusCode == STATUS_NOT_ENABLED) {
            this.log.trace("fireDeviceStatusEvent: STATUS_NOT_ENABLED " + statusCode);
        }
        switch (statusCode) {
            case 11: {
                this.log.trace("SCAL_SUE_STABLE_WEIGHT");
                break;
            }
            case 12: {
                this.log.trace("SCAL_SUE_WEIGHT_UNSTABLE");
                break;
            }
            case 13: {
                this.log.trace("SCAL_SUE_WEIGHT_ZERO");
                break;
            }
            case 14: {
                this.log.trace("SCAL_SUE_WEIGHT_OVERWEIGHT");
                break;
            }
            case 15: {
                this.log.trace("SCAL_SUE_NOT_READY");
                break;
            }
            case 16: {
                this.log.trace("SCAL_SUE_WEIGHT_UNDER_ZERO");
            }
        }
        Enumeration e = this.deviceStatusListeners.elements();
        while (e.hasMoreElements()) {
            DeviceErrorStatusListener listener = (DeviceErrorStatusListener)e.nextElement();
            listener.onDeviceStatusUpdate(statusCode);
        }
        this.log.debug("fireDeviceStatusEvent");
    }

    public void addDirectIODataListener(DirectIODataListener dl) {
        this.log.debug("addDirectIODataListener");
        this.directIODataListeners.addElement(dl);
        this.log.debug("addDirectIODataListener");
    }

    public void removeDirectIODataListener(DirectIODataListener dl) {
        this.log.debug("removeDirectIODataListener");
        boolean re = this.directIODataListeners.removeElement(dl);
        this.log.debug("removeDirectIODataListener");
    }

    protected void fireDirectIODataEvent(int cmd, byte[] buf) {
        this.log.debug("fireDirectIODataEvent: " + cmd);
        Enumeration e = this.deviceErrorListeners.elements();
        while (e.hasMoreElements()) {
            DirectIODataListener listener = (DirectIODataListener)e.nextElement();
            listener.onDirectIOData(cmd, buf);
        }
        this.log.debug("fireDirectIODataEvent");
    }

    public boolean hasStatisticsReporting() {
        return false;
    }

    public Hashtable getStatistics() throws XLException {
        throw new XLException(-2147483642, "getStatistics not supported for this device.");
    }

    public Hashtable returnStatistics() throws XLException {
        throw new XLException(-2147483642, "getStatistics not supported for this device.");
    }

    public static XLDevice createDevice(XLDeviceInfo info) {
        if (info.getCategory() == "Scanner") {
            return new XLScanner(info);
        }
        return null;
    }
}

