/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.service;

import com.xl.jpos.service.ItemReceivedListener;
import com.xl.jpos.service.LabelReceivedListener;
import com.xl.jpos.service.XLDevice;
import com.xl.jpos.service.XLDeviceInfo;
import com.xl.jpos.service.XLException;
import com.xl.util.XLBarcode;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import jpos.ScannerConst;

public class XLScanner
extends XLDevice
implements ScannerConst {
    public static final int ACK = 6;
    public static final int NAK = 21;
    public static final int CAN = 24;
    public static final int BEL = 7;
    public static final int UNKWN = 239;
    public static final int NRESP = 255;
    public int nRecordTimeout;
    protected int nResponse;
    protected Vector<LabelReceivedListener> labelReceivedListeners;
    protected Vector<ItemReceivedListener> itemReceivedListeners;
    protected boolean bSendCookedData;
    protected boolean bConvertBCDtoASCII;
    private boolean bDecodeData;
    int typeLength;
    byte prefix;
    byte suffix;

    public XLScanner(XLDeviceInfo info) {
        super(info);
        this.nRecordTimeout = this.nTimeout;
        this.nResponse = 0;
        this.labelReceivedListeners = new Vector();
        this.itemReceivedListeners = new Vector();
        this.bSendCookedData = false;
        this.bConvertBCDtoASCII = true;
        this.bDecodeData = false;
        this.typeLength = 2;
        this.prefix = 0;
        this.suffix = 0;
        this.prefix = info.getDataPrefix();
        this.suffix = info.getDataTrailer();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.bEnabled = enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.bEnabled;
    }

    public void setDecodeData(boolean decodeData) {
        this.bDecodeData = decodeData;
    }

    @Override
    public void SetParam(Set paramSet) {
    }

    @Override
    public String getModelNumber() {
        return "0.01";
    }

    @Override
    public String getSerialNumber() {
        return "0.01";
    }

    @Override
    public String getFirmwareVersion() {
        return "0.01";
    }

    @Override
    public boolean isAlive() throws XLException {
        return true;
    }

    @Override
    public int sendJoin() {
        return 1;
    }

    @Override
    public int sendReset() {
        return 1;
    }

    @Override
    public int directIO(int command, int[] data, Object paramObject) throws XLException {
        int result = 0;
        byte[] cmds = null;
        byte cmd = (byte)(command & 0xFF);
        byte para = 0;
        if (data != null && data.length > 0) {
            para = (byte)(data[0] & 0xFF);
        }
        byte[] byArray = new byte[11];
        byArray[0] = 87;
        byArray[2] = 23;
        byArray[3] = cmd;
        byArray[5] = para;
        byArray[7] = 1;
        byArray[9] = 85;
        cmds = byArray;
        result = this.sendData(cmds);
        return result;
    }

    @Override
    public void reset() throws XLException {
    }

    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        this.log.debug("onDataReceived start.");
        String str = new String(inBuf, 0, inLen);
        String[] pieces = str.split("\\+");
        if (pieces != null) {
            int i = 0;
            while (i < pieces.length) {
                if (pieces[i].length() != 0) {
                    int bcType = 0;
                    byte[] rawData = XLBarcode.addPrefixTrailer(pieces[i].getBytes(), this.prefix, this.suffix);
                    byte[] labelData = new byte[]{};
                    if (this.bDecodeData) {
                        bcType = Integer.parseInt(pieces[i].substring(0, this.typeLength), 16);
                        byte[] decodeLabelData = new byte[rawData.length - this.typeLength];
                        System.arraycopy(rawData, this.typeLength, decodeLabelData, 0, rawData.length - this.typeLength);
                        labelData = XLBarcode.addPrefixTrailer(decodeLabelData, this.prefix, this.suffix);
                    }
                    this.fireLabelReceivedEvent(rawData, labelData, bcType);
                }
                ++i;
            }
        }
    }

    protected void fireLabelReceivedEvent(byte[] rawLabel, byte[] decodeLabel, int nType) {
        this.log.debug("fireLabelReceivedEvent start.");
        Enumeration<LabelReceivedListener> e = this.labelReceivedListeners.elements();
        while (e.hasMoreElements()) {
            LabelReceivedListener listener = e.nextElement();
            listener.onLabelReceived(rawLabel, decodeLabel, nType);
        }
        this.log.debug("fireLabelReceivedEvent end successful.");
    }

    protected void fireItemReceivedEvent(byte[] rawItemData) {
        Enumeration<ItemReceivedListener> e = this.itemReceivedListeners.elements();
        while (e.hasMoreElements()) {
            ItemReceivedListener listener = e.nextElement();
            listener.onItemReceived(rawItemData);
        }
        this.log.debug("fireItemReceivedEvent");
    }

    protected String[] splitMessage(byte[] inBuf) {
        String str = "";
        this.parseMessages(inBuf, (byte)3);
        for (byte[] buf : this.msgList) {
            int i = 0;
            while (i < buf.length) {
                int n = buf[i] = buf[i] == 3 ? 44 : buf[i];
                if (buf[i] >= 32 || buf[i] <= 126) {
                    str = String.valueOf(str) + (char)buf[i];
                }
                ++i;
            }
        }
        this.bs.reset();
        this.msgList.clear();
        return str.split(",");
    }

    protected void parseMessages(byte[] inBuf, byte endChar, boolean bUseBCC) {
        int i = 0;
        while (i < inBuf.length) {
            boolean add;
            byte[] tmpBuf;
            this.bs.write(inBuf[i]);
            if (this.bNeedBCC) {
                this.bNeedBCC = false;
                tmpBuf = this.bs.toByteArray();
                add = this.msgList.add(tmpBuf);
                this.bs.reset();
            } else if (inBuf[i] == endChar) {
                if (bUseBCC) {
                    this.bNeedBCC = true;
                } else {
                    tmpBuf = this.bs.toByteArray();
                    add = this.msgList.add(tmpBuf);
                    this.bs.reset();
                }
            }
            ++i;
        }
    }

    protected void parseMessages(byte[] inBuf, byte endChar) {
        this.parseMessages(inBuf, endChar, false);
    }

    public void addLabelReceivedListener(LabelReceivedListener drl) {
        this.labelReceivedListeners.addElement(drl);
        this.log.debug("addLabelReceivedListener");
    }

    public void removeLabelReceivedListener(LabelReceivedListener drl) {
        this.labelReceivedListeners.removeElement(drl);
        this.log.debug("removeLabelReceivedListener");
    }

    public void addItemReceivedListener(ItemReceivedListener drl) {
        this.itemReceivedListeners.addElement(drl);
        this.log.debug("addItemReceivedListener");
    }

    public void removeItemReceivedListener(ItemReceivedListener drl) {
        this.itemReceivedListeners.removeElement(drl);
        this.log.debug("removeItemReceivedListener");
    }
}

