/*
 * Decompiled with CFR 0.152.
 */
package com.xl.util;

import com.xl.util.XLProperties;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class DefaultProperties
implements XLProperties {
    private Properties xlProperties = null;
    private HashMap multiPropMap = new HashMap();
    private String loadedPropFileName = "";
    private boolean loaded = false;
    private Exception lastException = null;
    private static Comparator propComparator = null;
    public static final String STRING_LIST_SEPARATOR = ",";
    private static DefaultProperties defaultProperties = null;

    @Override
    public void loadProperties() {
        this.loadPropertiesByName("xl.properties");
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public String getPropertyString(String propName) {
        String propValue = "";
        if (System.getProperties().containsKey(propName)) {
            propValue = System.getProperties().getProperty(propName);
        } else if (this.xlProperties != null) {
            propValue = this.xlProperties.getProperty(propName);
        }
        return propValue;
    }

    @Override
    public boolean isPropertyDefined(String propName) {
        if (System.getProperties().containsKey(propName)) {
            return true;
        }
        if (this.xlProperties != null) {
            return this.xlProperties.containsKey(propName);
        }
        return false;
    }

    public Enumeration getPropertyNames() {
        return this.getProperties().keys();
    }

    @Override
    public XLProperties.MultiProperty getMultiProperty(String multiPropName) {
        return (XLProperties.MultiProperty)this.multiPropMap.get(multiPropName);
    }

    @Override
    public boolean hasMultiProperty(String multiPropName) {
        return this.multiPropMap.containsKey(multiPropName);
    }

    @Override
    public int size() {
        return this.xlProperties.size();
    }

    public List getStringListProperty(String propName) {
        String propValue = this.getPropertyString(propName);
        ArrayList<String> list = new ArrayList<String>();
        if (propValue == null) {
            return list;
        }
        StringTokenizer st = new StringTokenizer(propValue, STRING_LIST_SEPARATOR);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<AppProperties>\n");
        Enumeration propNames = this.getPropertyNames();
        ArrayList list = new ArrayList();
        while (propNames.hasMoreElements()) {
            list.add(propNames.nextElement());
        }
        Collections.sort(list);
        for (String propName : list) {
            String propValue = this.getPropertyString(propName);
            sb.append("<name = \"" + propName + "\"" + " value = \"" + propValue + "\" />\n");
        }
        sb.append("</AppProperties>\n");
        return sb.toString();
    }

    public static Comparator propComparator() {
        if (propComparator == null) {
            propComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof XLProperties.Prop)) {
                        return -1;
                    }
                    if (!(o2 instanceof XLProperties.Prop)) {
                        return -1;
                    }
                    String o1Name = ((XLProperties.Prop)o1).getName();
                    String o2Name = ((XLProperties.Prop)o2).getName();
                    return o1Name.compareTo(o2Name);
                }
            };
        }
        return propComparator;
    }

    public static Iterator getDefinedPropertyNames() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < PROP_NAME_ARRAY.length) {
            list.add(PROP_NAME_ARRAY[i]);
            ++i;
        }
        return list.iterator();
    }

    protected void createMultiProperties() {
        Enumeration<Object> propNames = this.xlProperties.keys();
        while (propNames.hasMoreElements()) {
            MultiProp multiProp;
            String propName = (String)propNames.nextElement();
            String propValue = (String)this.xlProperties.get(propName);
            if (!this.isMultiProp(propName)) continue;
            String multiPropBaseName = this.getMultiPropBaseName(propName);
            if (this.multiPropMap.containsKey(multiPropBaseName)) {
                multiProp = (MultiProp)this.multiPropMap.get(multiPropBaseName);
                multiProp.add(propName, propValue);
                continue;
            }
            DefaultProperties defaultProperties = this;
            defaultProperties.getClass();
            multiProp = defaultProperties.new MultiProp(multiPropBaseName);
            multiProp.add(propName, propValue);
            this.multiPropMap.put(multiPropBaseName, multiProp);
        }
    }

    protected boolean isMultiProp(String propName) {
        if (propName.indexOf(".") == -1) {
            return false;
        }
        int dotIndex = propName.lastIndexOf(".");
        String numberString = propName.substring(dotIndex + 1);
        int number = -1;
        try {
            number = Integer.parseInt(numberString);
        }
        catch (NumberFormatException nfe) {
            number = -1;
        }
        return number >= 0;
    }

    protected String getMultiPropBaseName(String propName) throws IllegalArgumentException {
        if (!this.isMultiProp(propName)) {
            throw new IllegalArgumentException("getMultiPropBaseName( propName ) expects a propName that is a MuliProp");
        }
        return propName.substring(0, propName.lastIndexOf("."));
    }

    @Override
    public Iterator getProps() {
        ArrayList<Prop> list = new ArrayList<Prop>();
        Enumeration names = this.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = this.getPropertyString(name);
            Prop prop = new Prop(name, value);
            list.add(prop);
        }
        return list.iterator();
    }

    void loadPropertiesByName(String propFileName) {
        this.loaded = false;
        this.lastException = null;
        this.xlProperties = this.findProperties(propFileName);
        this.createMultiProperties();
    }

    String getLoadedPropFileName() {
        return this.loadedPropFileName;
    }

    Properties getProperties() {
        if (this.xlProperties == null) {
            this.loadProperties();
        }
        return this.xlProperties;
    }

    Properties findProperties(String propFileName) {
        Properties properties = new Properties();
        this.loadedPropFileName = propFileName;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.loadedPropFileName);
        if (is != null) {
            is = new BufferedInputStream(is);
            try {
                try {
                    properties.load(is);
                    this.loaded = true;
                }
                catch (Exception e) {
                    this.loaded = false;
                    this.loadedPropFileName = "";
                    this.lastException = e;
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        System.err.println("Unexpected exception while closing stream Exception.message = " + e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {
                    System.err.println("Unexpected exception while closing stream Exception.message = " + e.getMessage());
                }
            }
        } else {
            this.loaded = false;
            System.err.println(String.valueOf(propFileName) + " file not found");
        }
        return properties;
    }

    public static DefaultProperties getInstance() {
        if (defaultProperties == null) {
            defaultProperties = new DefaultProperties();
            defaultProperties.loadProperties();
        }
        return defaultProperties;
    }

    class MultiProp
    implements XLProperties.MultiProperty {
        private String basePropName = "";
        private HashMap propMap = new HashMap();

        MultiProp(String s) {
            this.basePropName = s;
        }

        @Override
        public String getBasePropertyName() {
            return this.basePropName;
        }

        @Override
        public Iterator getPropertyNames() {
            return this.propMap.keySet().iterator();
        }

        @Override
        public Iterator getSortedPropertyNames() {
            ArrayList namesList = new ArrayList(this.propMap.keySet());
            Collections.sort(namesList);
            return namesList.iterator();
        }

        @Override
        public Iterator getPropertyValues() {
            return this.propMap.values().iterator();
        }

        @Override
        public String getPropertyString(String propName) {
            return (String)this.propMap.get(propName);
        }

        @Override
        public String getPropertyString(int i) throws IllegalArgumentException {
            if (i < 0) {
                throw new IllegalArgumentException("Cannot find property in multiprop with number i = " + i);
            }
            return this.getPropertyString(String.valueOf(this.getBasePropertyName()) + "." + i);
        }

        @Override
        public int getNumberOfProperties() {
            return this.propMap.size();
        }

        @Override
        public int propertyNumber(String propName) throws IllegalArgumentException {
            return this.validatePropName(propName);
        }

        int validatePropName(String propName) throws IllegalArgumentException {
            if (!propName.startsWith(String.valueOf(this.getBasePropertyName()) + ".")) {
                throw new IllegalArgumentException("propName = " + propName + " passed does not match base prop name of " + this.getBasePropertyName());
            }
            if (propName.endsWith(".")) {
                throw new IllegalArgumentException("propName = " + propName + " passed must end with a pattern .<number>");
            }
            String numberString = propName.substring(propName.lastIndexOf(".") + 1);
            int number = 0;
            try {
                number = Integer.parseInt(numberString);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("propName = " + propName + " passed must end with a pattern .<number>");
            }
            return number;
        }

        void add(String propName, String propValue) throws IllegalArgumentException {
            this.validatePropName(propName);
            this.propMap.put(propName, propValue);
        }

        String remove(String propName) {
            return (String)this.propMap.remove(propName);
        }
    }

    public static class Prop
    implements XLProperties.Prop {
        private String name = "";
        private String value = "";

        public Prop(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setName(String s) {
            this.name = s;
        }

        @Override
        public void setValue(String s) {
            this.value = s;
        }

        @Override
        public int compareTo(XLProperties.Prop other) {
            if (other == null) {
                return -1;
            }
            return this.getName().compareTo(other.getName());
        }

        @Override
        public int compareTo(Object other) {
            return this.compareTo((XLProperties.Prop)other);
        }

        public boolean equals(Object otherProp) {
            if (otherProp == null) {
                return false;
            }
            if (!(otherProp instanceof XLProperties.Prop)) {
                return false;
            }
            XLProperties.Prop prop = (XLProperties.Prop)otherProp;
            return this.getName().equals(prop.getName()) && this.getValue().equals(prop.getValue());
        }

        public String toString() {
            return "<name = " + this.getName() + ", value = " + this.getValue() + ">";
        }
    }
}

