/*
 * Decompiled with CFR 0.152.
 */
package com.xl.util;

import com.xl.util.Logger;

public class XLBarcode {
    public static final int XL_TMP_D2 = 210;
    public static final int XL_NOT_APP = 0;
    public static final int XL_CODE_39 = 1;
    public static final int XL_CODABAR = 2;
    public static final int XL_CODE_128 = 3;
    public static final int XL_D2OF5 = 4;
    public static final int XL_IATA = 5;
    public static final int XL_I2OF5 = 6;
    public static final int XL_CODE93 = 7;
    public static final int XL_UPCA = 8;
    public static final int XL_UPCE0 = 9;
    public static final int XL_EAN8 = 10;
    public static final int XL_EAN13 = 11;
    public static final int XL_CODE11 = 12;
    public static final int XL_CODE49 = 13;
    public static final int XL_MSI = 14;
    public static final int XL_EAN128 = 15;
    public static final int XL_UPCE1 = 16;
    public static final int XL_PDF417 = 17;
    public static final int XL_CODE16K = 18;
    public static final int XL_C39FULL = 19;
    public static final int XL_UPCD = 20;
    public static final int XL_TRIOPTIC = 21;
    public static final int XL_BOOKLAND = 22;
    public static final int XL_COUPON = 23;
    public static final int XL_NW7 = 24;
    public static final int XL_ISBT128 = 25;
    public static final int XL_MICRO_PDF = 26;
    public static final int XL_DATAMATRIX = 27;
    public static final int XL_QR_CODE = 28;
    public static final int XL_MICRO_PDF_CCA = 29;
    public static final int XL_POSTNET_US = 30;
    public static final int XL_PLANET_CODE = 31;
    public static final int XL_CODE_32 = 32;
    public static final int XL_ISBT128_CON = 33;
    public static final int XL_JAPAN_POSTAL = 34;
    public static final int XL_AUS_POSTAL = 35;
    public static final int XL_DUTCH_POSTAL = 36;
    public static final int XL_MAXICODE = 37;
    public static final int XL_CANADIN_POSTAL = 38;
    public static final int XL_UK_POSTAL = 39;
    public static final int XL_MACRO_PDF = 40;
    public static final int XL_FR_LOT = 42;
    public static final int XL_MICRO_QR_CODE = 44;
    public static final int XL_AZTEC = 45;
    public static final int XL_RSS14 = 48;
    public static final int XL_RSS_LIMITET = 49;
    public static final int XL_RSS_EXPANDED = 50;
    public static final int XL_PARAMETER = 51;
    public static final int XL_4STATE_US = 52;
    public static final int XL_4STATE_US4 = 53;
    public static final int XL_ISSN = 54;
    public static final int XL_SCANLET = 55;
    public static final int XL_CUECODE = 56;
    public static final int XL_MATRIX2OF5 = 57;
    public static final int XL_UPCA_2 = 72;
    public static final int XL_UPCE0_2 = 73;
    public static final int XL_EAN8_2 = 74;
    public static final int XL_EAN13_2 = 75;
    public static final int XL_UPCE1_2 = 80;
    public static final int XL_CCA_EAN128 = 81;
    public static final int XL_CCA_EAN13 = 82;
    public static final int XL_CCA_EAN8 = 83;
    public static final int XL_CCA_RSS_EXPANDED = 84;
    public static final int XL_CCA_RSS_LIMITED = 85;
    public static final int XL_CCA_RSS14 = 86;
    public static final int XL_CCA_UPCA = 87;
    public static final int XL_CCA_UPCE = 88;
    public static final int XL_CCC_EAN128 = 89;
    public static final int XL_TLC39 = 90;
    public static final int XL_CCB_EAN128 = 97;
    public static final int XL_CCB_EAN13 = 98;
    public static final int XL_CCB_EAN8 = 99;
    public static final int XL_CCB_RSS_EXPANDED = 100;
    public static final int XL_CCB_RSS_LIMITED = 101;
    public static final int XL_CCB_RSS14 = 102;
    public static final int XL_CCB_UPCA = 103;
    public static final int XL_CCB_UPCE = 104;
    public static final int XL_SIGNATURE_CAPTURE = 105;
    public static final int XL_MOA = 106;
    public static final int XL_PDF417_PARAMETER = 112;
    public static final int XL_CHINESE2OF5 = 114;
    public static final int XL_KOREAN2OF5 = 115;
    public static final int XL_DATAMATRIX_PARAMETER = 116;
    public static final int XL_CODEZ = 117;
    public static final int XL_UPCA_5 = 136;
    public static final int XL_UPCE0_5 = 137;
    public static final int XL_EAN8_5 = 138;
    public static final int XL_EAN13_5 = 139;
    public static final int XL_UPCE1_5 = 144;
    public static final int XL_MACRO_MICRO_PDF = 154;
    public static final int XL_OCRB = 160;
    public static final int XL_OCR = 161;
    public static final int XL_PARSED_DL = 177;
    public static final int XL_PARSED_UID = 178;
    public static final int XL_PARSED_NDC = 179;
    public static final int XL_DATABAR_COUPON = 180;
    public static final int XL_ISO15434 = 181;
    public static final int XL_PARSED_XML = 182;
    public static final int XL_HAN_XIN_CODE = 183;
    public static final int XL_CALIBRATION = 192;
    public static final int XL_GS1_DATAMATRIX = 193;
    public static final int XL_GS1_QR = 194;
    public static final int XL_MAILMARK = 195;
    public static final int XL_DOTCODE = 196;
    public static final int XL_PSTAGE = 197;
    public static final int XL_MULTICODE = 198;
    public static final int XL_UK_PLESSEY = 199;
    public static final int XL_GRID_MATRIX = 200;
    public static final int XL_HP_LINK = 201;

    public static byte[] expandUPCE(byte[] labelData) {
        byte[] newLabel = new byte[11];
        int i = 0;
        try {
            switch (labelData[6]) {
                case 48: 
                case 49: 
                case 50: {
                    i = 0;
                    while (i < 3) {
                        newLabel[i] = labelData[i];
                        ++i;
                    }
                    newLabel[3] = labelData[6];
                    i = 4;
                    while (i < 8) {
                        newLabel[i] = 48;
                        ++i;
                    }
                    i = 8;
                    while (i < 11) {
                        newLabel[i] = labelData[i - 5];
                        ++i;
                        i = 0;
                        while (i < 4) {
                            newLabel[i] = labelData[i];
                            ++i;
                        }
                        i = 4;
                        while (i < 9) {
                            newLabel[i] = 48;
                            ++i;
                        }
                        i = 9;
                        while (i < 11) {
                            newLabel[i] = labelData[i - 5];
                            ++i;
                            i = 0;
                            while (i < 5) {
                                newLabel[i] = labelData[i];
                                ++i;
                            }
                            i = 5;
                            while (i < 10) {
                                newLabel[i] = 48;
                                ++i;
                            }
                            i = 10;
                            while (i < 11) {
                                newLabel[i] = labelData[i - 5];
                                ++i;
                                i = 0;
                                while (i < 6) {
                                    newLabel[i] = labelData[i];
                                    ++i;
                                }
                                i = 6;
                                while (i < 10) {
                                    newLabel[i] = 48;
                                    ++i;
                                }
                                i = 10;
                                while (i < 11) {
                                    newLabel[i] = labelData[i - 4];
                                    ++i;
                                }
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.getInstance().error("[BarcodeUtil] expandUPCE error: converting UPCE to UPCA");
        }
        return newLabel;
    }

    public static byte[] addCheckDigit(byte[] labelData) {
        int mult = 0;
        int sum = 0;
        int i = labelData.length - 1;
        while (i >= 0) {
            mult = i % 2 != labelData.length % 2 ? 3 : 1;
            sum += (labelData[i] - 48) * mult;
            --i;
        }
        if ((sum %= 10) != 0) {
            sum = 10 - sum;
        }
        byte[] newData = new byte[labelData.length + 1];
        System.arraycopy(labelData, 0, newData, 0, labelData.length);
        newData[labelData.length] = (byte)(sum + 48);
        return newData;
    }

    public static byte[] addPrefixTrailer(byte[] data, byte prefix, byte suffix) {
        if (data == null) {
            return null;
        }
        byte[] result = null;
        if (prefix != 0 && suffix != 0) {
            result = new byte[data.length + 2];
            System.arraycopy(data, 0, result, 1, data.length);
            result[0] = prefix;
            result[data.length + 1] = suffix;
        } else if (prefix != 0) {
            result = new byte[data.length + 1];
            System.arraycopy(data, 0, result, 1, data.length);
            result[0] = prefix;
        } else if (suffix != 0) {
            result = new byte[data.length + 1];
            System.arraycopy(data, 0, result, 0, data.length);
            result[data.length] = suffix;
        } else {
            result = data;
        }
        return result;
    }

    public static byte[] justifyLabelData(int nType, byte[] labelData) {
        switch (nType) {
            case 9: {
                if (labelData.length >= 8) break;
                byte[] newLabel = XLBarcode.expandUPCE((byte[])labelData);
                newLabel = XLBarcode.addCheckDigit((byte[])newLabel);
                byte[] upceLabel = new byte[8];
                System.arraycopy(labelData, 0, upceLabel, 0, 7);
                upceLabel[7] = newLabel[11];
                labelData = upceLabel;
                break;
            }
            case 8: {
                if (labelData.length >= 12) break;
                labelData = XLBarcode.addCheckDigit((byte[])labelData);
                break;
            }
            case 10: {
                if (labelData.length >= 8) break;
                labelData = XLBarcode.addCheckDigit((byte[])labelData);
                break;
            }
            case 11: {
                if (labelData.length >= 13) break;
                labelData = XLBarcode.addCheckDigit((byte[])labelData);
            }
        }
        return labelData;
    }

    public static void justifyBCDData(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        int len = data.length;
        int i = 0;
        while (i < len) {
            if (data[i] < 32) {
                data[i] = (byte)(data[i] + 48);
            }
            ++i;
        }
    }
}

