/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.xml.AbstractXercesRegPopulator;
import jpos.util.JposEntryUtility;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesRegPopulator
extends AbstractXercesRegPopulator {
    private Tracer tracer = TracerFactory.getInstance().createTracer("XercesRegPopulator");
    public static final String DTD_JAR_FILE_NAME = "/jpos/res/jcl.dtd";
    public static final String XERCES_REG_POPULATOR_NAME_STRING = "JCL XML Entries Populator";
    static /* synthetic */ Class class$jpos$config$simple$xml$XercesRegPopulator;

    public XercesRegPopulator() {
        super((class$jpos$config$simple$xml$XercesRegPopulator == null ? (class$jpos$config$simple$xml$XercesRegPopulator = XercesRegPopulator.class$("jpos.config.simple.xml.XercesRegPopulator")) : class$jpos$config$simple$xml$XercesRegPopulator).getName());
    }

    public XercesRegPopulator(String string) {
        super(string);
    }

    public String getClassName() {
        return (class$jpos$config$simple$xml$XercesRegPopulator == null ? (class$jpos$config$simple$xml$XercesRegPopulator = XercesRegPopulator.class$("jpos.config.simple.xml.XercesRegPopulator")) : class$jpos$config$simple$xml$XercesRegPopulator).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.tracer.println("load(): isPopulatorFileDefined=" + this.isPopulatorFileDefined());
        if (!this.isPopulatorFileDefined()) {
            this.getJposEntries().clear();
            this.xmlFileName = "jpos.xml";
            this.load(this.xmlFileName);
            return;
        }
        try {
            this.getJposEntries().clear();
            this.domParser.setEntityResolver((EntityResolver)new JPOSDTDEntityResolver());
            this.domParser.parse(new InputSource(this.getPopulatorFileIS()));
            Document document = this.domParser.getDocument();
            Enumeration enumeration = this.extractJposEntries(document);
            while (enumeration.hasMoreElements()) {
                JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                if (!jposEntry.hasPropertyWithName("logicalName")) continue;
                this.getJposEntries().put(jposEntry.getLogicalName(), jposEntry);
            }
            this.lastLoadException = null;
        }
        catch (Exception exception) {
            this.lastLoadException = exception;
            this.tracer.println("Error loading XML file.  Exception.msg = " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) {
        this.tracer.println("load: xmlFileName=" + string);
        InputStream inputStream = null;
        File file = new File(string);
        try {
            inputStream = file.exists() ? new FileInputStream(file) : this.findFileInClasspath(string);
            if (inputStream == null) {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            }
            if (inputStream == null) {
                this.getJposEntries().clear();
                this.tracer.println("Could not find file: " + string + " in path or CLASSPATH");
                this.lastLoadException = new FileNotFoundException(string);
                return;
            }
            this.lastLoadException = null;
        }
        catch (Exception exception) {
            this.lastLoadException = exception;
            this.tracer.println("Error loading XML file.  Exception.message = " + exception.getMessage());
        }
        try {
            this.getJposEntries().clear();
            this.domParser.setEntityResolver((EntityResolver)new JPOSDTDEntityResolver());
            this.domParser.parse(new InputSource(inputStream));
            Document document = this.domParser.getDocument();
            Enumeration enumeration = this.extractJposEntries(document);
            while (enumeration.hasMoreElements()) {
                JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                if (!jposEntry.hasPropertyWithName("logicalName")) continue;
                this.getJposEntries().put(jposEntry.getLogicalName(), jposEntry);
            }
            this.lastLoadException = null;
        }
        catch (Exception exception) {
            this.lastLoadException = exception;
            this.tracer.println("Error loading XML file.  Exception.message = " + exception.getMessage());
        }
    }

    public String getName() {
        return XERCES_REG_POPULATOR_NAME_STRING;
    }

    protected Enumeration extractJposEntries(Document document) {
        Vector<SimpleEntry> vector;
        block9: {
            vector = new Vector<SimpleEntry>();
            NodeList nodeList = document.getElementsByTagName("JposEntry");
            String string = "";
            try {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    SimpleEntry simpleEntry = new SimpleEntry();
                    Element element = (Element)node;
                    string = element.getAttribute("logicalName");
                    simpleEntry.addProperty("logicalName", string);
                    NodeList nodeList2 = nodeList.item(i).getChildNodes();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Node node2 = nodeList2.item(j);
                        if (node2.getNodeType() != 1) continue;
                        Element element2 = (Element)node2;
                        String string2 = element2.getNodeName();
                        if (string2.equals("creation")) {
                            this.extractCreationAttr(simpleEntry, element2);
                            continue;
                        }
                        if (string2.equals("vendor")) {
                            this.extractVendorAttr(simpleEntry, element2);
                            continue;
                        }
                        if (string2.equals("jpos")) {
                            this.extractJposAttr(simpleEntry, element2);
                            continue;
                        }
                        if (string2.equals("product")) {
                            this.extractProductAttr(simpleEntry, element2);
                            continue;
                        }
                        this.extractPropAttr(simpleEntry, element2);
                    }
                    if (JposEntryUtility.isValidJposEntry(simpleEntry)) {
                        vector.addElement(simpleEntry);
                        continue;
                    }
                    String string3 = "JposEntry with logicalName: " + string + " is not valid (missing required properties)";
                    throw new JposConfigException(string3);
                }
            }
            catch (JposConfigException jposConfigException) {
                this.tracer.println("Skipping invalid entry with logicalName: " + string);
                this.tracer.println("--->JposConfigException.message = " + jposConfigException.getMessage());
                this.tracer.print(jposConfigException);
                if (jposConfigException.getOrigException() == null) break block9;
                this.tracer.print(jposConfigException.getOrigException());
            }
        }
        return vector.elements();
    }

    protected void extractCreationAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("serviceInstanceFactoryClass", element.getAttribute("factoryClass"));
        jposEntry.addProperty("serviceClass", element.getAttribute("serviceClass"));
    }

    protected void extractVendorAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("vendorName", element.getAttribute("name"));
        jposEntry.addProperty("vendorURL", element.getAttribute("url"));
    }

    protected void extractJposAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("jposVersion", element.getAttribute("version"));
        jposEntry.addProperty("deviceCategory", element.getAttribute("category"));
    }

    protected void extractProductAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("productName", element.getAttribute("name"));
        jposEntry.addProperty("productDescription", element.getAttribute("description"));
        jposEntry.addProperty("productURL", element.getAttribute("url"));
    }

    protected void extractPropAttr(JposEntry jposEntry, Element element) throws JposConfigException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("value");
        String string3 = element.getAttribute("type");
        if (string3.equals("")) {
            string3 = "String";
        }
        Object object = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3.startsWith("java.lang.") ? string3 : "java.lang." + string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JposConfigException("Invalid property type: " + string3 + " for property named: " + string, classNotFoundException);
        }
        if (!JposEntryUtility.isValidPropType(clazz)) {
            throw new JposConfigException("Invalid property type: " + string3 + " for property named: " + string);
        }
        object = JposEntryUtility.parsePropValue(string2, clazz);
        if (!JposEntryUtility.validatePropValue(object, clazz)) {
            throw new JposConfigException("Invalid property type: " + string3 + " for property named: " + string);
        }
        jposEntry.add(jposEntry.createProp(string, object, clazz));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class JPOSDTDEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            InputStream inputStream;
            if (string.equals("-//JavaPOS//DTD//EN") && (inputStream = this.getClass().getResourceAsStream(XercesRegPopulator.DTD_JAR_FILE_NAME)) != null) {
                return new InputSource(new InputStreamReader(inputStream));
            }
            return null;
        }
    }
}

