/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.JposEntryConst;
import jpos.config.RS232Const;
import jpos.config.simple.SimpleEntry;

public class JposEntryUtility {
    private static JposEntry prototypeJposEntry;
    private static final List STANDARD_PROP_NAMES_LIST;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    private JposEntryUtility() {
    }

    public static boolean isValidJposEntry(JposEntry jposEntry) {
        boolean bl = false;
        if (jposEntry.hasPropertyWithName("logicalName") && jposEntry.hasPropertyWithName("serviceInstanceFactoryClass") && jposEntry.hasPropertyWithName("serviceClass") && jposEntry.hasPropertyWithName("deviceCategory") && jposEntry.hasPropertyWithName("jposVersion") && jposEntry.hasPropertyWithName("vendorName") && jposEntry.hasPropertyWithName("vendorURL") && jposEntry.hasPropertyWithName("productName") && jposEntry.hasPropertyWithName("productURL") && jposEntry.hasPropertyWithName("productDescription")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRequiredPropName(String string) {
        boolean bl = false;
        if (string.equals("logicalName") || string.equals("serviceInstanceFactoryClass") || string.equals("serviceClass") || string.equals("deviceCategory") || string.equals("jposVersion") || string.equals("vendorName") || string.equals("vendorURL") || string.equals("productName") || string.equals("productURL") || string.equals("productDescription")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRS232PropName(String string) {
        boolean bl = false;
        if (string.equals("portName") || string.equals("baudRate") || string.equals("dataBits") || string.equals("parity") || string.equals("stopBits") || string.equals("flowControl")) {
            bl = true;
        }
        return bl;
    }

    public static void removeAllRS232Props(JposEntry jposEntry) {
        jposEntry.removeProperty("portName");
        jposEntry.removeProperty("baudRate");
        jposEntry.removeProperty("dataBits");
        jposEntry.removeProperty("parity");
        jposEntry.removeProperty("stopBits");
        jposEntry.removeProperty("flowControl");
    }

    public static Iterator getStandardPropNames() {
        return STANDARD_PROP_NAMES_LIST.iterator();
    }

    public static Enumeration getNonRequiredPropNames(JposEntry jposEntry) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = jposEntry.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (JposEntryUtility.isRequiredPropName(string)) continue;
            vector.add(string);
        }
        return vector.elements();
    }

    public static Enumeration getMissingRequiredPropNames(JposEntry jposEntry) {
        Vector<String> vector = new Vector<String>();
        if (!jposEntry.hasPropertyWithName("logicalName")) {
            vector.add("logicalName");
        }
        if (!jposEntry.hasPropertyWithName("serviceInstanceFactoryClass")) {
            vector.add("serviceInstanceFactoryClass");
        }
        if (!jposEntry.hasPropertyWithName("serviceClass")) {
            vector.add("serviceClass");
        }
        if (!jposEntry.hasPropertyWithName("deviceCategory")) {
            vector.add("deviceCategory");
        }
        if (!jposEntry.hasPropertyWithName("jposVersion")) {
            vector.add("jposVersion");
        }
        if (!jposEntry.hasPropertyWithName("vendorName")) {
            vector.add("vendorName");
        }
        if (!jposEntry.hasPropertyWithName("vendorURL")) {
            vector.add("vendorURL");
        }
        if (!jposEntry.hasPropertyWithName("productName")) {
            vector.add("productName");
        }
        if (!jposEntry.hasPropertyWithName("productURL")) {
            vector.add("productURL");
        }
        if (!jposEntry.hasPropertyWithName("productDescription")) {
            vector.add("productDescription");
        }
        return vector.elements();
    }

    public static Enumeration getMissingRS232PropNames(JposEntry jposEntry) {
        Vector<String> vector = new Vector<String>();
        if (!jposEntry.hasPropertyWithName("portName")) {
            vector.add("portName");
        }
        if (!jposEntry.hasPropertyWithName("baudRate")) {
            vector.add("baudRate");
        }
        if (!jposEntry.hasPropertyWithName("dataBits")) {
            vector.add("dataBits");
        }
        if (!jposEntry.hasPropertyWithName("parity")) {
            vector.add("parity");
        }
        if (!jposEntry.hasPropertyWithName("stopBits")) {
            vector.add("stopBits");
        }
        if (!jposEntry.hasPropertyWithName("flowControl")) {
            vector.add("flowControl");
        }
        return vector.elements();
    }

    public static Enumeration getVendorPropNames(JposEntry jposEntry) {
        Vector vector = new Vector();
        Enumeration enumeration = jposEntry.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Iterator iterator = JposEntryUtility.getStandardPropNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            vector.remove(string);
        }
        return vector.elements();
    }

    public static void addMissingRequiredProps(JposEntry jposEntry) {
        Enumeration enumeration = JposEntryUtility.getMissingRequiredPropNames(jposEntry);
        JposEntry jposEntry2 = JposEntryUtility.getEntryPrototype();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            jposEntry.addProperty(string, jposEntry2.getPropertyValue(string));
        }
    }

    public static JposEntry getEntryPrototype() {
        if (prototypeJposEntry == null) {
            prototypeJposEntry = new SimpleEntry();
            prototypeJposEntry.addProperty("logicalName", "UnknownDevice");
            prototypeJposEntry.addProperty("serviceInstanceFactoryClass", "UnknownServiceInstanceFactoryClass");
            prototypeJposEntry.addProperty("serviceClass", "UnknownServiceClass");
            prototypeJposEntry.addProperty("deviceCategory", "CashDrawer");
            prototypeJposEntry.addProperty("jposVersion", "1.5");
            prototypeJposEntry.addProperty("vendorName", "Unknown Vendor Name");
            prototypeJposEntry.addProperty("vendorURL", "http://www.UnknownVerdorURL.com");
            prototypeJposEntry.addProperty("productName", "Unknown Product Name");
            prototypeJposEntry.addProperty("productURL", "http://www.UnknownProductURL.com");
            prototypeJposEntry.addProperty("productDescription", "Unknown Product Description");
        }
        return ((SimpleEntry)prototypeJposEntry).copy();
    }

    public static String shortClassName(Class clazz) {
        return clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1);
    }

    public static boolean validatePropValue(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return false;
        }
        if (!JposEntryUtility.isValidPropType(clazz)) {
            return false;
        }
        return clazz.isInstance(object);
    }

    public static boolean isValidPropType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        for (int i = 0; i < JposEntryConst.PROP_TYPES.length; ++i) {
            if (!clazz.equals(JposEntryConst.PROP_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    public static Object getDefaultValueForType(Class clazz) throws JposConfigException {
        if (!JposEntryUtility.isValidPropType(clazz)) {
            throw new JposConfigException("Invalid property type: " + clazz);
        }
        Object object = "";
        try {
            if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JposEntryUtility.class$("java.lang.String")) : class$java$lang$String)) {
                object = "";
            } else if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JposEntryUtility.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                object = new Boolean(false);
            } else if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = JposEntryUtility.class$("java.lang.Character")) : class$java$lang$Character)) {
                object = new Character('a');
            } else if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JposEntryUtility.class$("java.lang.Double")) : class$java$lang$Double)) {
                object = new Double(0.0);
            } else if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JposEntryUtility.class$("java.lang.Float")) : class$java$lang$Float)) {
                object = new Float(0.0f);
            } else if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JposEntryUtility.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                object = new Byte(0);
            } else if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JposEntryUtility.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                object = new Integer(0);
            } else if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JposEntryUtility.class$("java.lang.Long")) : class$java$lang$Long)) {
                object = new Long(0L);
            } else if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JposEntryUtility.class$("java.lang.Short")) : class$java$lang$Short)) {
                object = new Short(0);
            }
        }
        catch (Exception exception) {
            throw new JposConfigException("Invalid property type");
        }
        return object;
    }

    public static Object parsePropValue(String string, Class clazz) throws JposConfigException {
        if (!JposEntryUtility.isValidPropType(clazz)) {
            throw new JposConfigException("Invalid property type: " + clazz);
        }
        Object object = "";
        try {
            if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JposEntryUtility.class$("java.lang.String")) : class$java$lang$String)) {
                object = string;
            } else if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JposEntryUtility.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                object = Boolean.valueOf(string);
            } else if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = JposEntryUtility.class$("java.lang.Character")) : class$java$lang$Character)) {
                object = new Character(string.charAt(0));
            } else if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JposEntryUtility.class$("java.lang.Double")) : class$java$lang$Double)) {
                object = Double.valueOf(string);
            } else if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JposEntryUtility.class$("java.lang.Float")) : class$java$lang$Float)) {
                object = Float.valueOf(string);
            } else if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JposEntryUtility.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                object = Byte.decode(string);
            } else if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JposEntryUtility.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                object = Integer.decode(string);
            } else if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JposEntryUtility.class$("java.lang.Long")) : class$java$lang$Long)) {
                object = Long.decode(string);
            } else if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JposEntryUtility.class$("java.lang.Short")) : class$java$lang$Short)) {
                object = Short.decode(string);
            }
        }
        catch (Exception exception) {
            throw new JposConfigException("Could not create property value of type: " + clazz + " from string: " + string);
        }
        return object;
    }

    public static Class propTypeFromString(String string) throws JposConfigException {
        if (string == null) {
            throw new JposConfigException("typeString cannot be null");
        }
        String string2 = string.startsWith("java.lang.") ? string : "java.lang." + string;
        try {
            Class<?> clazz = Class.forName(string2);
            if (!JposEntryUtility.isValidPropType(clazz)) {
                throw new JposConfigException("Invalid property type: " + string);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JposConfigException("Invalid typeString", classNotFoundException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        prototypeJposEntry = null;
        STANDARD_PROP_NAMES_LIST = new ArrayList();
        for (n = 0; n < JposEntryConst.REQUIRED_PROPS.length; ++n) {
            STANDARD_PROP_NAMES_LIST.add(JposEntryConst.REQUIRED_PROPS[n]);
        }
        STANDARD_PROP_NAMES_LIST.add("deviceBus");
        for (n = 0; n < RS232Const.RS232_PROPS.length; ++n) {
            STANDARD_PROP_NAMES_LIST.add(RS232Const.RS232_PROPS[n]);
        }
    }
}

