﻿#include <stdio.h>
#include <stdlib.h>
#include <iconv.h>
#include "tspl_sdk_api.h"

//UTF-8转gb2312，仅在linux系统编码模式为utf-8且需要打印中文的时候调用
int utf8Togb2312( char *inbuf, int inlen, char *outbuf, int outlen)
{
	iconv_t cd;
	char **pin = &inbuf;
	char **pout = &outbuf;

	cd = iconv_open("GB2312","UTF-8");

	if (cd == 0)
	return -1;

	memset(outbuf, 0, outlen);

	if (iconv(cd, pin, &inlen, pout, &outlen) == -1)
	return 1;

	iconv_close(cd);
	return 0;
}

void test_tspl()
{
    void *phandle = NULL;
    int result = 0;
    char error_msg[1024] = {0};


    result = PrinterCreator(&phandle, "HT130");

    if (0 != result)
    {
        FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        printf("%s\n", error_msg);
        return;
    }

    result = PortOpen(phandle, "USB,HT130,vid=0x20D1,pid=0x7007");
    if (0 != result)
    {
        FormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        printf("%s\n", error_msg);
    }
    else
    {
        result = TSPL_ClearBuffer(phandle);

        result = TSPL_Setup(phandle,30,120,2,6,1,0,0);


       //CODE128
        result = TSPL_BarCode(phandle,40,0,0,50,1,0,2,2,"128");

        //CODE93
         result = TSPL_BarCode(phandle,40,80,8,50,1,0,2,2,"01234567890238");

        //EAN13
        result = TSPL_BarCode(phandle,40,160,9,50,1,0,2,2,"012345678902");

        //UPCA
        result = TSPL_BarCode(phandle,40,240,17,50,1,0,2,2,"01234567811");

        //QRCODE
        result = TSPL_QrCode(phandle, 40, 330, 3, 3, 0, 0, 0, 7, "1000000001");
        result = TSPL_QrCode(phandle,120,330,3,3,0,0,0,7,"11111111");

        //打印矩形或直线
        result = TSPL_Box(phandle, 40,400,150,550,3);

        //打印图像（路径为图像路径）
        result = TSPL_PrintImage(phandle, 40, 600, 0, "/home/liu/Documents/1-x.bmp");

	char *pGb2312 = "你好"; 
	char cText[128] = { 0 };
	result = utf8Togb2312(pGb2312, strlen(pGb2312), cText, sizeof(cText));
	result = TSPL_Text(phandle, 120, 800, 9, 0, 20, 20, cText);

        result = TSPL_Print(phandle, 1, 1);
	//打印自检页
        result = TSPL_SelfTest(phandle);	

    }

    result = PortClose(phandle);

    result = PrinterDestroy(phandle);
}

int main()
{
    test_tspl();
    return 0;
}

